let deferredPrompt = null;

const askModal        = () => document.getElementById('modal-install-ask');
const installingModal = () => document.getElementById('modal-installing');
const doneModal       = () => document.getElementById('modal-done');

function show(el)  { if (el) el.style.display = 'flex'; }
function hide(el)  { if (el) el.style.display = 'none'; }

if ('serviceWorker' in navigator) {
  window.addEventListener('load', () => {
    navigator.serviceWorker
      .register('service-worker.js')
      .catch(err => console.log('SW error:', err));
  });
}

window.addEventListener('beforeinstallprompt', (e) => {
  e.preventDefault();
  deferredPrompt = e;
  show(askModal());
});

window.startRanchoInstall = async () => {
  if (!deferredPrompt) {
    alert('Si no aparece el cuadro de instalación, abre este enlace en Google Chrome.');
    return;
  }
  hide(askModal());
  show(installingModal());
  deferredPrompt.prompt();
  const choice = await deferredPrompt.userChoice;
  hide(installingModal());
  if (choice.outcome === 'accepted') {
    show(doneModal());
  }
  deferredPrompt = null;
};

window.cancelRanchoInstall = () => {
  hide(askModal());
  window.location.href = 'about:blank';
};

window.openRanchoWeb = () => {
  window.location.href = 'https://rest.tecnomaniagt.com/irestora_plus/Authentication/login.php';
};